import argparse
import os
from util import util
import torch

class BaseOptions():
	def __init__(self):
		self.parser = argparse.ArgumentParser()
		self.initialized = False

	def initialize(self):
		self.parser.add_argument('--datarootTarget', required=True, help='path to real images (should have subfolders trainA, trainB, valA, valB, etc)')
		self.parser.add_argument('--datarootData', required=True, help='path to experiment images (should have subfolders trainA, trainB, valA, valB, etc)')
		self.parser.add_argument('--datarootValTarget',default= '../Dataset/chaomo/test/B_flip_val',help='path to validation real images (should have subfolders trainA, trainB, valA, valB, etc)')
		self.parser.add_argument('--datarootValData', default = '../Dataset/chaomo/test/B_flip_val',help='path to validation images')
		self.parser.add_argument('--batchSize', type=int, default=1, help='input batch size')
		self.parser.add_argument('--loadSizeX', type=int, default=640, help='scale images to this size')
		self.parser.add_argument('--loadSizeY', type=int, default=360, help='scale images to this size')
		self.parser.add_argument('--fineSize', type=int, default=256, help='then crop to this size')
		self.parser.add_argument('--input_nc', type=int, default=3, help='# of input image channels')
		self.parser.add_argument('--output_nc', type=int, default=3, help='# of output image channels')
		self.parser.add_argument('--ngf', type=int, default=64, help='# of gen filters in first conv layer')
		self.parser.add_argument('--ndf', type=int, default=64, help='# of discrim filters in first conv layer')
		self.parser.add_argument('--which_model_netD', type=str, default='basic', help='selects model to use for netD')
		self.parser.add_argument('--which_model_netG', type=str, default='resnet_9blocks', help='selects model to use for netG')
		self.parser.add_argument('--learn_residual', action='store_true', help='if specified, model would learn only the residual to the input')
		self.parser.add_argument('--gan_type', type=str, default='wgan-gp', help='wgan-gp : Wasserstein GAN with Gradient Penalty, lsgan : Least Sqaures GAN, gan : Vanilla GAN')
		self.parser.add_argument('--n_layers_D', type=int, default=3, help='only used if which_model_netD==n_layers')
		self.parser.add_argument('--gpu_ids', type=str, default='0', help='gpu ids: e.g. 0  0,1,2, 0,2. use -1 for CPU')
		self.parser.add_argument('--name', type=str, default='experiment_name', help='name of the experiment. It decides where to store samples and models')
		self.parser.add_argument('--dataset_mode', type=str, default='single', help='chooses how datasets are loaded. [unaligned | aligned | single]')
		self.parser.add_argument('--model', type=str, default='content_gan', help='chooses which model to use. pix2pix, test, content_gan')
		self.parser.add_argument('--which_direction', type=str, default='AtoB', help='AtoB or BtoA')
		self.parser.add_argument('--nThreads', default=2, type=int, help='# threads for loading data')
		self.parser.add_argument('--checkpoints_dir', type=str, default='./checkpoints', help='models are saved here')
		self.parser.add_argument('--norm', type=str, default='instance', help='instance normalization or batch normalization')
		self.parser.add_argument('--which_data', type=str, default='chaomo', help='set the kind of data, with 3 choices: MNIST, chaomo, anime')
		self.parser.add_argument('--which_ep', type=str, default='last', help='the epoch of AE model used in OT')
		self.parser.add_argument('--serial_batches', action='store_true', help='if true, takes images in order to make batches, otherwise takes them randomly')
		self.parser.add_argument('--display_winsize', type=int, default=256,  help='display window size')
		self.parser.add_argument('--display_id', type=int, default=1, help='window id of the web display')
		self.parser.add_argument('--display_port', type=int, default=9099, help='visdom port of the web display')
		self.parser.add_argument('--display_single_pane_ncols', type=int, default=0, help='if positive, display all images in a single visdom web panel with certain number of images per row.')
		self.parser.add_argument('--no_dropout', action='store_true', help='no dropout for the generator')
		self.parser.add_argument('--max_dataset_size', type=int, default=float("inf"), help='Maximum number of samples allowed per dataset. If the dataset directory contains more than max_dataset_size, only a subset is loaded.')
		self.parser.add_argument('--resize_or_crop', type=str, default='resize_and_crop', help='scaling and cropping of images at load time [resize_and_crop|crop|scale_width|scale_width_and_crop]')
		self.parser.add_argument('--no_flip', action='store_true', help='if specified, do not flip the images for data augmentation')
		self.parser.add_argument('--lr_e', type=float, default=0.0002, help='learning rate of the encoder, default=0.0002')
		self.parser.add_argument('--lr_g', type=float, default=0.0002, help='learning rate of the generator, default=0.0002')
		self.parser.add_argument("--num_vae", type=int, default=0, help="the epochs of pretraining a VAE, Default=0")
		self.parser.add_argument("--weight_neg", type=float, default=1.0, help="Default=1.0")
		self.parser.add_argument("--weight_rec", type=float, default=1.0, help="Default=1.0")
		self.parser.add_argument("--weight_kl", type=float, default=1.0, help="Default=1.0")
		self.parser.add_argument("--m_plus", type=float, default=100.0, help="the margin in the adversarial part, Default=100.0")
		self.parser.add_argument('--channels', default="64, 128, 256, 512, 512, 512", type=str, help='the list of channel numbers')
		self.parser.add_argument("--hdim", type=int, default=512, help="dim of the latent code, Default=512")
		self.parser.add_argument('--input_height', type=int, default=256, help='the height  of the input image to network')
		self.parser.add_argument('--input_width', type=int, default=None, help='the width  of the input image to network')
		self.parser.add_argument('--output_height', type=int, default=256, help='the height  of the output image to network')
		self.parser.add_argument('--output_width', type=int, default=None, help='the width  of the output image to network')
		self.parser.add_argument("--momentum", default=0.9, type=float, help="Momentum, Default: 0.9")
		self.parser.add_argument('--clip', type=float, default=100, help='the threshod for clipping gradient')
		self.parser.add_argument("--step", type=int, default=500, help="Sets the learning rate to the initial LR decayed by momentum every n epochs, Default: n=500")
		self.initialized = True

	def parse(self):
		if not self.initialized:
			self.initialize()
		self.opt = self.parser.parse_args()
		self.opt.isTrain = self.isTrain

		str_ids = self.opt.gpu_ids.split(',')
		self.opt.gpu_ids = []
		for str_id in str_ids:
			id = int(str_id)
			if id >= 0:
				self.opt.gpu_ids.append(id)

		# set gpu ids
		if len(self.opt.gpu_ids) > 0:
			torch.cuda.set_device(self.opt.gpu_ids[0])

		args = vars(self.opt)

		print('------------ Options -------------')
		for k, v in sorted(args.items()):
			print('%s: %s' % (str(k), str(v)))
		print('-------------- End ----------------')

		# save to the disk
		expr_dir = os.path.join(self.opt.checkpoints_dir, self.opt.name)
		util.mkdirs(expr_dir)
		file_name = os.path.join(expr_dir, 'opt.txt')
		with open(file_name, 'wt') as opt_file:
			opt_file.write('------------ Options -------------\n')
			for k, v in sorted(args.items()):
				opt_file.write('%s: %s\n' % (str(k), str(v)))
			opt_file.write('-------------- End ----------------\n')
		return self.opt
